/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class ExampleMixin
extends ClassLoader {
    private final Map<String, byte[]> classDefinitions;
    private final Map<String, byte[]> resourceDefinitions;

    public ExampleMixin(Map<String, byte[]> classDefinitions, Map<String, byte[]> resourceDefinitions) {
        super(ClassLoader.getSystemClassLoader());
        this.classDefinitions = classDefinitions;
        this.resourceDefinitions = resourceDefinitions;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.classDefinitions.get(name);
        if (bytes == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] data = this.resourceDefinitions.get(name);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        if (name.startsWith("/") && (data = this.resourceDefinitions.get(name.substring(1))) != null) {
            return new ByteArrayInputStream(data);
        }
        return super.getResourceAsStream(name);
    }
}

